/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.header;

import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfig;
import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfigCategory;
import com.teamresourceful.resourcefulconfig.client.UIConstants;
import com.teamresourceful.resourcefulconfig.client.components.ModSprites;
import com.teamresourceful.resourcefulconfig.client.components.base.ContainerWidget;
import com.teamresourceful.resourcefulconfig.client.components.base.SpriteButton;
import com.teamresourceful.resourcefulconfig.client.components.options.types.StringOptionWidget;
import com.teamresourceful.resourcefulconfig.client.utils.ConfigSearching;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.network.chat.Component;

public class HeaderControlsWidget
extends ContainerWidget {
    private final LinearLayout layout = LinearLayout.horizontal().spacing(5);

    public HeaderControlsWidget(int width, ResourcefulConfig config, Runnable onSearchUpdate) {
        super(0, 0, width, 0);
        boolean willGoBack = config instanceof ResourcefulConfigCategory;
        this.layout.addChild((LayoutElement)SpriteButton.builder(12, 12).padding(2).sprite(!willGoBack ? ModSprites.CROSS : ModSprites.CHEVRON_LEFT).onPress(() -> Minecraft.getInstance().screen.onClose()).tooltip(!willGoBack ? UIConstants.CLOSE : UIConstants.BACK).build());
        StringOptionWidget searchWidget = new StringOptionWidget(ConfigSearching::getSearch, name -> {
            if (ConfigSearching.setSearch(name)) {
                onSearchUpdate.run();
            }
            return true;
        }, false);
        searchWidget.setWidth(this.width - 20 - 16 - 5);
        searchWidget.setHint((Component)Component.literal((String)"Search...").withColor(-9276296));
        this.layout.addChild((LayoutElement)searchWidget);
        this.layout.arrangeElements();
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget(x$0);
        });
        this.height = this.layout.getHeight() + 20;
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.blitSprite(ModSprites.CONTAINER, this.getX(), this.getY(), this.width, this.height);
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void positionUpdated() {
        this.layout.setPosition(this.getX() + 10, this.getY() + 10);
    }
}

